#include "stdinc.h"
#include "pce.h"
#include "pg.h"
#include "string.h"

#define	VRR	2
#define MinLine	io.minline
#define MaxLine io.maxline

extern int ScrollYDiff;
extern int scroll;
extern int oldScrollX;
extern int oldScrollY;
extern int oldScrollYDiff;

//-------------------------------------------------------------------
// 
// VDC WRITE ACCESS
// 
//-------------------------------------------------------------------
void VDC_write(word A,byte V)
{
    switch(A&3){
      case 0: io.vdc_reg = V&31; return;
      case 1:                    return;
      case 2: // VDC ʃoCg

        io.VDC[io.vdc_reg].B.l = V;

        switch(io.vdc_reg){
          case VWR:
            //io.VDC[VWR].B.l = V;
            //io.vdc_ratch = V;
            return;
          case HDR:
            io.screen_w = ((V&0x7f)+1) * 8;// (V+1)*8;
            break;
          case MWR: {
              static byte bgw[]={32,64,128,128};
              io.bg_h=(V&0x40)?64:32;
              io.bg_w=bgw[(V>>4)&3];

#if 1         // LbVNA
              _memset(vchange,1,VRAMSIZE/32);
#ifdef USE_SPRITE_CACHE
              _memset(vchanges,1,VRAMSIZE/128);
#endif //USE_SPRITE_CACHE
#endif
          }
            //TRACE("bg:%dx%d, V:%X\n",io.bg_w,io.bg_h, V);
            //TRACE("MWRl: %02X\n", V);
            break;
          case BYR:
            if (!scroll) {
                oldScrollX = ScrollX;
                oldScrollY = ScrollY;
                oldScrollYDiff = ScrollYDiff;
            }
            //io.VDC[BYR].B.l = V;
            scroll=1;
            ScrollYDiff=scanline-1;
            return;
          case BXR:
            if (!scroll) {
                oldScrollX = ScrollX;
                oldScrollY = ScrollY;
                oldScrollYDiff = ScrollYDiff;
            }
            //io.VDC[BXR].B.l = V;
            scroll=1;
            return;
        }
        
        return;
        
        //-------------------------------------------
        // VDC ʃoCg
        //-------------------------------------------
      case 3:
        io.VDC[io.vdc_reg].B.h = V;

        //printf("vdc_h%d,%02x ",io.vdc_reg,V);
        switch(io.vdc_reg){
          case VWR:
            VRAM[io.VDC[MAWR].W*2+0]=io.VDC[VWR].B.l;
            VRAM[io.VDC[MAWR].W*2+1]=io.VDC[VWR].B.h;
            
            vchange[io.VDC[MAWR].W/16]=1;
#if defined(USE_SPRITE_CACHE)
            vchanges[io.VDC[MAWR].W/64]=1;
#endif //defined(USE_SPRITE_CACHE)
            io.VDC[MAWR].W+=io.vdc_inc;
            //io.vdc_ratch=0;
            return;
          case VDW:
            //io.VDC[VDW].B.l = io.VDC_ratch[VDW];
            //io.VDC[VDW].B.h = V;
            io.screen_h = (io.VDC[VDW].W&511)+1;
            MaxLine = io.screen_h-1;
            //TRACE("VDWh: %X\n", io.VDC[VDW].W);
            return;
          case LENR:
            //io.VDC[LENR].B.l = io.VDC_ratch[LENR];
            //io.VDC[LENR].B.h = V;
            //TRACE("DMA:%04x %04x %04x\n",io.VDC[DISTR].W,io.VDC[SOUR].W,io.VDC[LENR].W);
            /* VRAM to VRAM DMA */
            
            // XvCg̃Rs[sۂH
            _memcpy(VRAM+io.VDC[DISTR].W*2,VRAM+io.VDC[SOUR].W*2,(io.VDC[LENR].W+1)*2);

            //ύXtOĂۂ
            _memset(vchange+io.VDC[DISTR].W/16,1,(io.VDC[LENR].W+1)/16);
            _memset(vchange+io.VDC[DISTR].W/64,1,(io.VDC[LENR].W+1)/64);
            io.VDC[DISTR].W += io.VDC[LENR].W+1;
            io.VDC[SOUR].W += io.VDC[LENR].W+1;

            // add by e
            io.VDC[LENR].W = 0;
            // add by e
            
            io.vdc_status|=VDC_DMAfinish;
            return;
            
          case CR :{
              static byte incsize[]={1,32,64,128};
              io.vdc_inc = incsize[(V>>3)&3];
              //TRACE("CRh: %02X\n", V);
          } break;
          case HDR:
            //io.screen_w = (io.VDC_ratch[HDR]+1)*8;
            //TRACE0("HDRh\n");
            break;
          case BYR:
            if (!scroll) {
                oldScrollX = ScrollX;
                oldScrollY = ScrollY;
                oldScrollYDiff = ScrollYDiff;
            }
            io.VDC[BYR].B.h = V&1;
            scroll=1;
            ScrollYDiff=scanline-1;
            return;

          case SATB:
            //io.VDC[SATB].B.h = V;
            //TRACE("SATB=%X,scanline=%d\n", io.VDC[SATB].W, scanline);
            io.vdc_satb=1;
            io.vdc_status&=~VDC_SATBfinish;
            return;

          case BXR:
            if (!scroll) {
                oldScrollX = ScrollX;
                oldScrollY = ScrollY;
                oldScrollYDiff = ScrollYDiff;
            }
            io.VDC[BXR].B.h = V & 3;
            scroll=1;
            //			ScrollX = io.VDC[BXR].W;
            //			TRACE("BXRh = %d, scanline = %d\n", io.VDC[BXR].W, scanline);
            //			io.VDC[BXR].W = 256;
            return;
        }
        
        //io.VDC[io.vdc_reg].B.l = io.VDC_ratch[io.vdc_reg];
        //io.VDC[io.vdc_reg].B.h = V;
        //		if (io.vdc_reg != CR)
        //			TRACE("vdc_h: %02X,%02X\n", io.vdc_reg, V);
        //if (io.vdc_reg>19) {
        //    //TRACE("ignore write hi vdc%d,%02x\n",io.vdc_reg,V);
        //}
        return;
    }
}

//-------------------------------------------------------------------
// 
// VDC READ ACCESS
// 
//-------------------------------------------------------------------
byte VDC_read(word A)
{
    byte ret;
    switch(A&3){
      case 0:
        ret = io.vdc_status;
        io.vdc_status=0;//&=VDC_InVBlank;//&=~VDC_BSY;
        return ret;
      case 1:
        return 0;
      case 2:
        if (io.vdc_reg==VRR) 
          return VRAM[io.VDC[MARR].W*2];
        //else return io.VDC[io.vdc_reg].B.l;
      case 3:
        if (io.vdc_reg==VRR) {
            ret = VRAM[io.VDC[MARR].W*2+1];
            io.VDC[MARR].W+=io.vdc_inc;
            return ret;
        }
        //else {
        //    return io.VDC[io.vdc_reg].B.h;
        //}
    }
    return 0;
}


